
local use_ed_wpn = true

local function clsid_ls6_100(use_ed)
    if use_ed then
        return "weapons.bombs.LS_6_100"
    else
        return "weapons.bombs.LS-6-100"
    end
end

local ls6_100_name  = 'MAM C AP'
local ls6_100_model = "ls-6-100"
local ls6_100_mass  = 6.5
local ls6_100_cx    = 0.00001
local pylon_mass    = 150.0

local ldout_cnt = 1

declare_loadout({
    category         = CAT_BOMBS,
    CLSID            = "DIS_LS_6_100",
    --attribute        = LS_6_100.wsTypeOfWeapon,
    attribute        = clsid_ls6_100(use_ed_wpn),
    Count            = ldout_cnt,
    Cx_pil           = ls6_100_cx,
    Picture          = "mam_c_ap.png",
    displayName      = _(ls6_100_name),
    Weight           = ls6_100_mass + pylon_mass,
    Elements         = {{ShapeName = ls6_100_model}},
    ejectVelocity    = eject_speed_msl1,
    ejectDirection   = {0, -1, 0},
})

ldout_cnt = 6

LS6_100_DUAL_L = {
    category         = CAT_BOMBS,
    CLSID            = "DIS_LS_6_100_DUAL_L",
    Count            = ldout_cnt,
    Cx_pil           = ls6_100_cx * ldout_cnt + 0.00122,
    Cx_item          = ls6_100_cx,
    Picture          = "mam_c_ap.png",
    displayName      = _(ls6_100_name .. " x6"),
    Weight           = ls6_100_mass * ldout_cnt + pylon_mass,
    Elements = {
        {
            ShapeName = "shitty_bru_wannabe",
            IsAdapter = true
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml001",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml002",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml003",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml004",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml005",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml006",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },		
    },
    --wsTypeOfWeapon   = LS_6_100.wsTypeOfWeapon,
    wsTypeOfWeapon   = clsid_ls6_100(use_ed_wpn),
    attribute        = {4, 5, 32, WSTYPE_PLACEHOLDER},
    ejectVelocity    = eject_speed_msl1,
    ejectDirection   = {0, -1, 0},
}
declare_loadout(LS6_100_DUAL_L)


LS6_100_DUAL_R = {
    category         = CAT_BOMBS,
    CLSID            = "DIS_LS_6_100_DUAL_R",
    Count            = ldout_cnt,
    Cx_pil           = ls6_100_cx * ldout_cnt + 0.00122,
    Cx_item          = ls6_100_cx,
    Picture          = "mam_c_ap.png",
    displayName      = _(ls6_100_name .. " x6"),
    Weight           = ls6_100_mass * ldout_cnt + pylon_mass,
    Elements = {
        {
            ShapeName = "shitty_bru_wannabe",
            IsAdapter = true
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml001",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml002",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml003",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml004",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml005",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },
        {
            ShapeName = ls6_100_model,
            connector_name = "maml006",
            DrawArgs  = {
                [1] = {1, 1.0},
            }
        },		
    },
    --wsTypeOfWeapon   = LS_6_100.wsTypeOfWeapon,
    wsTypeOfWeapon   = clsid_ls6_100(use_ed_wpn),
    attribute        = {4, 5, 32, WSTYPE_PLACEHOLDER},
    ejectVelocity    = eject_speed_msl1,
    ejectDirection   = {0, -1, 0},
}
declare_loadout(LS6_100_DUAL_R)
